/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;

public class VWMessageDialog
extends VWModalDialog
implements ActionListener,
ComponentListener {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    public static final int DEFAULT_OPTION = 16;
    public static final int YES_OPTION = 1;
    public static final int NO_OPTION = 2;
    public static final int CANCEL_OPTION = 4;
    public static final int OK_OPTION = 8;
    public static final int CLOSE_OPTION = 16;
    public static final int HELP_OPTION = 32;
    public static final int CONTINUE_OPTION = 64;
    private static final int MINIMUM_WIDTH = 420;
    private static final int MINIMUM_HEIGHT = 130;
    private JButton m_yesButton = null;
    private JButton m_noButton = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private JButton m_continueButton = null;
    private JTextArea m_messageTextArea = null;
    private JScrollPane m_scrollPane = null;
    private int m_optType = 16;
    private int m_buttonSelected = 16;
    private String m_helpURL = null;
    private Icon m_icon = null;

    public VWMessageDialog(Frame parent, String message, int msgType, int optionType, Icon icon, int width, int height) {
        super(parent);
        this.init(parent, message, msgType, optionType, icon, width, height);
    }

    public VWMessageDialog(Frame parent, String[] msgs, int msgType, int optionType, Icon icon, int width, int height) {
        super(parent);
        String message = null;
        if (msgs != null) {
            for (int i = 0; i < msgs.length; ++i) {
                message = message == null ? msgs[i] + "\r\n" : message + msgs[i] + "\r\n";
            }
        }
        this.init(parent, message, msgType, optionType, icon, width, height);
    }

    public VWMessageDialog(JDialog parent, String message, int msgType, int optionType, Icon icon, int width, int height) {
        super(parent);
        this.init(parent, message, msgType, optionType, icon, width, height);
    }

    public VWMessageDialog(JDialog parent, String[] msgs, int msgType, int optionType, Icon icon, int width, int height) {
        super(parent);
        String message = null;
        if (msgs != null) {
            for (int i = 0; i < msgs.length; ++i) {
                message = message == null ? msgs[i] + "\r\n" : message + msgs[i] + "\r\n";
            }
        }
        this.init(parent, message, msgType, optionType, icon, width, height);
    }

    public static int showOptionDialog(Frame parent, String message) {
        return VWMessageDialog.showOptionDialog(parent, message, null, 2, 16, null, 0, 0);
    }

    public static int showOptionDialog(Frame parent, String message, int msgType) {
        return VWMessageDialog.showOptionDialog(parent, message, null, msgType, 16, null, 0, 0);
    }

    public static int showOptionDialog(Frame parent, String message, String title, int msgType) {
        return VWMessageDialog.showOptionDialog(parent, message, title, msgType, 16, null, 0, 0);
    }

    public static int showOptionDialog(Frame parent, String message, String title, int msgType, int optionType, Icon icon, int width, int height) {
        return VWMessageDialog.showOptionDialog(parent, message, title, msgType, optionType, null, icon, width, height);
    }

    public static int showOptionDialog(Frame parent, String message, String title, int msgType, int optionType, String helpURL, Icon icon, int width, int height) {
        VWMessageDialog mDlg = new VWMessageDialog(parent, message, msgType, optionType, icon, width, height);
        try {
            if (title != null) {
                mDlg.setTitle(title);
            }
            if (helpURL != null) {
                mDlg.setHelpURL(helpURL);
            }
            mDlg.setVisible(true);
            mDlg.dispose();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mDlg.buttonSelected();
    }

    public static int showOptionDialog(Frame parent, String[] messages, int msgType) {
        return VWMessageDialog.showOptionDialog(parent, messages, null, msgType, 16, null, null, 0, 0);
    }

    public static int showOptionDialog(Frame parent, String[] messages, String title, int msgType) {
        return VWMessageDialog.showOptionDialog(parent, messages, title, msgType, 16, null, null, 0, 0);
    }

    public static int showOptionDialog(Frame parent, String[] messages, String title, int msgType, int optionType, Icon icon, int width, int height) {
        return VWMessageDialog.showOptionDialog(parent, messages, title, msgType, optionType, null, icon, width, height);
    }

    public static int showOptionDialog(Frame parent, String[] messages, String title, int msgType, int optionType, String helpURL, Icon icon, int width, int height) {
        VWMessageDialog mDlg = new VWMessageDialog(parent, messages, msgType, optionType, icon, width, height);
        try {
            if (title != null) {
                mDlg.setTitle(title);
            }
            if (helpURL != null) {
                mDlg.setHelpURL(helpURL);
            }
            mDlg.setVisible(true);
            mDlg.dispose();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mDlg.buttonSelected();
    }

    public static int showOptionDialog(JDialog parent, String message, int msgType) {
        return VWMessageDialog.showOptionDialog(parent, message, null, msgType, 16, null, 0, 0);
    }

    public static int showOptionDialog(JDialog parent, String message, String title, int msgType) {
        return VWMessageDialog.showOptionDialog(parent, message, title, msgType, 16, null, 0, 0);
    }

    public static int showOptionDialog(JDialog parent, String message, String title, int msgType, int optionType, Icon icon, int width, int height) {
        return VWMessageDialog.showOptionDialog(parent, message, title, msgType, optionType, null, icon, width, height);
    }

    public static int showOptionDialog(JDialog parent, String message, String title, int msgType, int optionType, String helpURL, Icon icon, int width, int height) {
        VWMessageDialog mDlg = new VWMessageDialog(parent, message, msgType, optionType, icon, width, height);
        try {
            if (title != null) {
                mDlg.setTitle(title);
            }
            if (helpURL != null) {
                mDlg.setHelpURL(helpURL);
            }
            mDlg.setVisible(true);
            mDlg.dispose();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mDlg.buttonSelected();
    }

    public static int showConfirmDialog(JDialog parent, String message) {
        return VWMessageDialog.showConfirmDialog(parent, message, VWResource.s_selectAnOption, 7);
    }

    public static int showConfirmDialog(JDialog parent, String message, String title, int optionType) {
        VWMessageDialog mDlg = new VWMessageDialog(parent, message, 4, optionType, null, 0, 0);
        try {
            mDlg.setTitle(title);
            mDlg.setVisible(true);
            mDlg.dispose();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mDlg.buttonSelected();
    }

    public static int showConfirmDialog(Frame parent, String message) {
        return VWMessageDialog.showConfirmDialog(parent, message, VWResource.s_selectAnOption, 7);
    }

    public static int showConfirmDialog(Frame parent, String message, String title, int optionType) {
        VWMessageDialog mDlg = new VWMessageDialog(parent, message, 4, optionType, null, 0, 0);
        try {
            mDlg.setTitle(title);
            mDlg.setVisible(true);
            mDlg.dispose();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mDlg.buttonSelected();
    }

    public void actionPerformed(ActionEvent event) {
        Object objSource = event.getSource();
        if (objSource == this.m_yesButton) {
            this.m_buttonSelected = 1;
            this.setVisible(false);
        }
        if (objSource == this.m_noButton) {
            this.m_buttonSelected = 2;
            this.setVisible(false);
        }
        if (objSource == this.m_okButton) {
            this.m_buttonSelected = 8;
            this.setVisible(false);
        }
        if (objSource == this.m_cancelButton) {
            this.m_buttonSelected = 4;
            this.setVisible(false);
        }
        if (objSource == this.m_closeButton) {
            this.m_buttonSelected = 16;
            this.setVisible(false);
        }
        if (objSource == this.m_continueButton) {
            this.m_buttonSelected = 64;
            this.setVisible(false);
        } else if (objSource == this.m_helpButton) {
            this.m_buttonSelected = 32;
            if (this.m_helpURL != null) {
                VWHelp.displayPage(this.m_helpURL);
            }
        }
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        JViewport viewport;
        if (e.getSource() != null && e.getSource() instanceof VWMessageDialog && this.m_scrollPane != null && (viewport = this.m_scrollPane.getViewport()) != null) {
            Dimension viewportSize = viewport.getSize();
            Dimension viewportPreferedSize = viewport.getPreferredSize();
            if (viewportSize != null && viewportPreferedSize != null) {
                double vpHeight = viewportSize.getHeight();
                double vpPreferedHeight = viewportPreferedSize.getHeight();
                if (vpPreferedHeight < vpHeight + 15.0) {
                    int diff = (int)(vpHeight - vpPreferedHeight);
                    Dimension size = this.getSize();
                    if (size.getHeight() - (double)diff > 130.0) {
                        this.setSize((int)size.getWidth(), (int)size.getHeight() - diff);
                    } else {
                        this.setSize((int)size.getWidth(), 130);
                    }
                } else if (this.m_messageTextArea != null) {
                    this.m_messageTextArea.setCaretPosition(0);
                }
            }
        }
        this.removeComponentListener(this);
    }

    public void componentHidden(ComponentEvent e) {
    }

    private void init(Window parent, String msg, int msgType, int optionType, Icon icon, int nWidth, int nHeight) {
        try {
            this.m_optType = optionType;
            this.m_icon = icon;
            this.m_messageTextArea = new JTextArea();
            this.m_messageTextArea.setLineWrap(true);
            this.m_messageTextArea.setWrapStyleWord(true);
            this.m_messageTextArea.setEditable(false);
            this.m_messageTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.m_messageTextArea.applyComponentOrientation(compOrientation);
            if (msg != null) {
                this.m_messageTextArea.setText(msg);
            }
            Color bgColor = this.getContentPane().getBackground();
            this.m_messageTextArea.setBackground(bgColor);
            Font boldFont = null;
            Font normalFont = this.getFont();
            if (normalFont != null) {
                boldFont = new Font(normalFont.getName(), 1, normalFont.getSize());
            }
            this.m_messageTextArea.setFont(boldFont);
            this.m_messageTextArea.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    this.handleEvent(e);
                }

                public void focusLost(FocusEvent e) {
                    this.handleEvent(e);
                }

                private void handleEvent(FocusEvent e) {
                    if (e != null && e.getSource() != null && e.getSource() instanceof JTextArea) {
                        Container parent = ((JTextArea)e.getSource()).getParent();
                        while (parent != null) {
                            if (parent instanceof JScrollPane) {
                                if ((parent = ((JScrollPane)parent).getParent()) == null || !(parent instanceof JPanel)) break;
                                ((JPanel)parent).setBorder(BorderFactory.createLineBorder(((JPanel)parent).getBackground()));
                                break;
                            }
                            if (!(parent instanceof JComponent)) continue;
                            parent = ((JComponent)parent).getParent();
                        }
                    }
                }
            });
            switch (msgType) {
                case 1: {
                    this.setTitle(VWResource.s_errorMessage);
                    if (this.m_icon != null) break;
                    this.m_icon = UIManager.getIcon("OptionPane.errorIcon");
                    break;
                }
                case 2: {
                    this.setTitle(VWResource.s_message);
                    if (this.m_icon != null) break;
                    this.m_icon = UIManager.getIcon("OptionPane.informationIcon");
                    break;
                }
                case 3: {
                    this.setTitle(VWResource.s_warningMessage);
                    if (this.m_icon != null) break;
                    this.m_icon = UIManager.getIcon("OptionPane.warningIcon");
                    break;
                }
                case 4: {
                    if (this.m_icon != null) break;
                    this.m_icon = UIManager.getIcon("OptionPane.questionIcon");
                }
            }
            if (nWidth <= 0 || nHeight <= 0) {
                Dimension dim = VWStringUtils.stringToDimension("445,225");
                if (dim == null) {
                    dim = new Dimension(420, 130);
                }
                this.setSize(dim);
                this.addComponentListener(this);
            } else {
                this.setSize(nWidth, nHeight);
            }
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.setVisible(false);
            this.getContentPane().add((Component)this.createMessagePanel(), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createMessagePanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 5);
            if (this.m_icon != null) {
                gbCons.fill = 0;
                gbCons.weightx = 0.0;
                gbCons.weighty = 0.0;
                JLabel iconLabel = new JLabel(this.m_icon);
                mainPanel.add((Component)iconLabel, gbCons);
                ++gbCons.gridx;
                VWAccessibilityHelper.setAccessibility(iconLabel, mainPanel, this.m_messageTextArea.getText(), this.m_messageTextArea.getText());
            }
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            this.m_scrollPane = new JScrollPane(this.m_messageTextArea);
            this.m_scrollPane.setBorder(null);
            mainPanel.add((Component)this.m_scrollPane, gbCons);
            mainPanel.setBorder(BorderFactory.createLineBorder(mainPanel.getBackground()));
            this.m_messageTextArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_messageTextArea, mainPanel, this.m_messageTextArea.getText(), this.m_messageTextArea.getText());
            mainPanel.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    VWMessageDialog.this.m_messageTextArea.requestFocus();
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private JPanel createButtonPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new FlowLayout());
            if ((this.m_optType & 1) == 1) {
                this.m_yesButton = new JButton(VWResource.s_yes);
                this.m_yesButton.addActionListener(this);
                mainPanel.add(this.m_yesButton);
                this.m_yesButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            if ((this.m_optType & 2) == 2) {
                this.m_noButton = new JButton(VWResource.s_no);
                this.m_noButton.addActionListener(this);
                mainPanel.add(this.m_noButton);
                this.m_noButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            if ((this.m_optType & 8) == 8) {
                this.m_okButton = new JButton(VWResource.s_ok);
                this.m_okButton.addActionListener(this);
                mainPanel.add(this.m_okButton);
                this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            if ((this.m_optType & 0x40) == 64) {
                this.m_continueButton = new JButton(VWResource.s_continue);
                this.m_continueButton.addActionListener(this);
                mainPanel.add(this.m_continueButton);
                this.m_continueButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            if ((this.m_optType & 4) == 4) {
                this.m_cancelButton = new JButton(VWResource.s_cancel);
                this.m_cancelButton.addActionListener(this);
                mainPanel.add(this.m_cancelButton);
                this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            if ((this.m_optType & 0x10) == 16) {
                this.m_closeButton = new JButton(VWResource.s_close);
                this.m_closeButton.addActionListener(this);
                mainPanel.add(this.m_closeButton);
                this.m_closeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            if ((this.m_optType & 0x20) == 32) {
                this.m_helpButton = new JButton(VWResource.s_help);
                this.m_helpButton.addActionListener(this);
                mainPanel.add(this.m_helpButton);
                this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_okButton != null) {
            this.m_okButton.requestFocus();
        } else if (this.m_yesButton != null) {
            this.m_yesButton.requestFocus();
        } else if (this.m_closeButton != null) {
            this.m_closeButton.requestFocus();
        } else if (this.m_continueButton != null) {
            this.m_continueButton.requestFocus();
        } else if (this.m_helpButton != null) {
            this.m_helpButton.requestFocus();
        } else if (this.m_noButton != null) {
            this.m_noButton.requestFocus();
        } else if (this.m_cancelButton != null) {
            this.m_cancelButton.requestFocus();
        }
        JScrollBar scrollBar = this.m_scrollPane.getVerticalScrollBar();
        scrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (e.getSource() != null && e.getSource() instanceof JScrollBar) {
                    JScrollBar sb = (JScrollBar)e.getSource();
                    boolean bFocusable = sb.getMaximum() != sb.getVisibleAmount();
                    for (Container parent = sb.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof JPanel)) continue;
                        parent.setFocusable(bFocusable);
                        VWMessageDialog.this.m_messageTextArea.setFocusable(bFocusable);
                        break;
                    }
                }
            }
        });
    }

    private int buttonSelected() {
        return this.m_buttonSelected;
    }

    private void setHelpURL(String helpURL) {
        this.m_helpURL = helpURL;
    }
}

